# Inventory Module

A comprehensive inventory management system for the Restaurant SaaS platform.

## Overview

The Inventory Module provides complete inventory tracking and management capabilities including:
- Stock level management
- Inventory items catalog
- Supplier management
- Purchase order handling
- Recipe/formula management
- Stock movements and transfers
- Comprehensive reporting and analytics
- Category and unit management

## Features

### Dashboard
- Overview of inventory status
- Quick statistics (total items, low stock alerts, out of stock items)
- Total inventory value
- Recent stock movements

### Items Management
- Add, edit, and delete inventory items
- Track SKUs and categories
- Set minimum stock levels
- Manage suppliers per item
- Add notes and descriptions

### Stock Management
- Real-time stock level tracking
- Stock adjustments (add, subtract, or set exact quantity)
- Low stock alerts
- Out of stock tracking
- Stock movement history

### Categories
- Organize items by categories
- Manage category details
- Filter inventory by category

### Units
- Define measurement units (kg, liters, units, etc.)
- Standard unit management
- Conversion support

### Suppliers
- Maintain supplier information
- Track contact details and payment terms
- Active/inactive supplier status
- Link items to suppliers

### Purchase Orders
- Create and manage purchase orders
- Track order status
- Receive goods and update stock
- Payment terms tracking
- Supplier order history

### Recipes/Formulas
- Define recipe compositions
- Track ingredients and quantities
- Calculate recipe costs
- Link recipes to menu items

### Stock Movements
- Track all inventory transfers
- Record adjustments with reasons
- Historical movement logs
- Location-based transfers

### Reports
- Stock value reports
- Low stock alerts
- Movement history
- Supplier performance
- Category-wise analysis

### Settings
- Configure inventory preferences
- Low stock warning thresholds
- Valuation method settings
- Automatic reorder points

## Installation

1. Extract the module to your modules directory
2. Run migrations: `php artisan migrate`
3. Configure permissions for your roles
4. Access via the Inventory menu in the application

## Database Schema

### inventory_items table
- id
- tenant_id
- name
- sku (unique)
- category
- current_stock
- minimum_stock
- unit_cost
- unit
- supplier_id (nullable, foreign key)
- notes
- timestamps

### suppliers table
- id
- tenant_id
- name
- contact_person
- phone
- email
- address
- payment_terms
- notes
- is_active
- timestamps

## Routes

All routes are prefixed with `/inventory` and require authentication:

- `GET /inventory/dashboard` - Dashboard view
- `GET|POST /inventory/items` - Items management
- `GET|POST /inventory/stock` - Stock management
- `GET|POST /inventory/categories` - Categories
- `GET|POST /inventory/units` - Units
- `GET|POST /inventory/suppliers` - Suppliers
- `GET|POST /inventory/purchase-orders` - Purchase orders
- `GET|POST /inventory/recipes` - Recipes
- `GET /inventory/movements` - Stock movements
- `GET /inventory/reports` - Reports
- `GET|PUT /inventory/settings` - Settings

## Permissions

- `view_inventory` - View inventory items
- `create_inventory` - Create new items
- `edit_inventory` - Edit existing items
- `delete_inventory` - Delete items
- `view_suppliers` - View suppliers
- `create_suppliers` - Add suppliers
- `edit_suppliers` - Edit suppliers
- `delete_suppliers` - Remove suppliers
- `manage_stock` - Adjust stock levels
- `view_reports` - Access reports
- `manage_recipes` - Create and edit recipes
- `manage_purchase_orders` - Create and manage POs

## Configuration

Settings can be configured through the module settings page, including:
- Low stock warning threshold
- Stock valuation method (FIFO, LIFO, Average Cost)
- Automatic reorder point calculation
- Default unit of measurement

## API Integration

The module provides RESTful API endpoints for:
- Retrieving inventory items and stock levels
- Creating and updating items
- Managing stock adjustments
- Supplier management
- Report generation

## Support

For issues, feature requests, or questions, please contact the development team.

## License

All rights reserved - Restaurant SaaS Platform
