<?php

use App\Http\Controllers\Tenant\Inventory\CategoriesController;
use App\Http\Controllers\Tenant\Inventory\ItemsController;
use App\Http\Controllers\Tenant\Inventory\MovementsController;
use App\Http\Controllers\Tenant\Inventory\PurchaseOrdersController;
use App\Http\Controllers\Tenant\Inventory\StockController;
use App\Http\Controllers\Tenant\Inventory\SuppliersController;
use App\Http\Controllers\Tenant\Inventory\UnitsController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'tenant'])->prefix('tenant/inventory')->name('tenant.inventory.')->group(function () {

    // Dashboard / Stock Overview
    Route::get('/', [StockController::class, 'index'])->name('index');
    Route::get('/stock', [StockController::class, 'index'])->name('stock.index');

    // Units Management
    Route::prefix('units')->name('units.')->group(function () {
        Route::get('/', [UnitsController::class, 'index'])->name('index');
        Route::post('/', [UnitsController::class, 'store'])->name('store');
        Route::put('/{unit}', [UnitsController::class, 'update'])->name('update');
        Route::delete('/{unit}', [UnitsController::class, 'destroy'])->name('destroy');
    });

    // Categories Management
    Route::prefix('categories')->name('categories.')->group(function () {
        Route::get('/', [CategoriesController::class, 'index'])->name('index');
        Route::post('/', [CategoriesController::class, 'store'])->name('store');
        Route::put('/{category}', [CategoriesController::class, 'update'])->name('update');
        Route::delete('/{category}', [CategoriesController::class, 'destroy'])->name('destroy');
    });

    // Items Management
    Route::prefix('items')->name('items.')->group(function () {
        Route::get('/', [ItemsController::class, 'index'])->name('index');
        Route::post('/', [ItemsController::class, 'store'])->name('store');
        Route::get('/{item}', [ItemsController::class, 'show'])->name('show');
        Route::put('/{item}', [ItemsController::class, 'update'])->name('update');
        Route::delete('/{item}', [ItemsController::class, 'destroy'])->name('destroy');
        Route::post('/{item}/adjust-stock', [ItemsController::class, 'adjustStock'])->name('adjust-stock');
    });

    // Suppliers Management
    Route::prefix('suppliers')->name('suppliers.')->group(function () {
        Route::get('/', [SuppliersController::class, 'index'])->name('index');
        Route::post('/', [SuppliersController::class, 'store'])->name('store');
        Route::get('/{supplier}', [SuppliersController::class, 'show'])->name('show');
        Route::put('/{supplier}', [SuppliersController::class, 'update'])->name('update');
        Route::delete('/{supplier}', [SuppliersController::class, 'destroy'])->name('destroy');
    });

    // Stock Movements
    Route::prefix('movements')->name('movements.')->group(function () {
        Route::get('/', [MovementsController::class, 'index'])->name('index');
    });

    // Purchase Orders
    Route::prefix('purchase-orders')->name('purchase_orders.')->group(function () {
        Route::get('/', [PurchaseOrdersController::class, 'index'])->name('index');
        Route::get('/create', [PurchaseOrdersController::class, 'create'])->name('create');
        Route::post('/', [PurchaseOrdersController::class, 'store'])->name('store');
        Route::get('/{purchaseOrder}', [PurchaseOrdersController::class, 'show'])->name('show');
        Route::get('/{purchaseOrder}/receive', [PurchaseOrdersController::class, 'receive'])->name('receive');
        Route::post('/{purchaseOrder}/receive', [PurchaseOrdersController::class, 'processReceive'])->name('process_receive');
        Route::post('/{purchaseOrder}/status', [PurchaseOrdersController::class, 'updateStatus'])->name('update_status');
        Route::delete('/{purchaseOrder}', [PurchaseOrdersController::class, 'destroy'])->name('destroy');
    });
});
