<x-layouts.tenant title="{{ $pageTitle ?? 'Inventory Dashboard' }}">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <!-- Page Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-secondary-900 dark:text-white">Inventory Dashboard</h1>
            <p class="mt-1 text-sm text-secondary-600 dark:text-secondary-400">Overview of your inventory management</p>
        </div>

        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white dark:bg-secondary-800 rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-secondary-600 dark:text-secondary-400">Total Items</p>
                        <p class="text-2xl font-bold text-secondary-900 dark:text-white">{{ $totalItems ?? 0 }}</p>
                    </div>
                    <div class="p-3 bg-primary-100 dark:bg-primary-900/20 rounded-full">
                        <svg class="w-6 h-6 text-primary-600 dark:text-primary-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-secondary-800 rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-secondary-600 dark:text-secondary-400">Low Stock Items</p>
                        <p class="text-2xl font-bold text-red-600 dark:text-red-400">{{ $lowStockItems ?? 0 }}</p>
                    </div>
                    <div class="p-3 bg-red-100 dark:bg-red-900/20 rounded-full">
                        <svg class="w-6 h-6 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-secondary-800 rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-secondary-600 dark:text-secondary-400">Total Value</p>
                        <p class="text-2xl font-bold text-secondary-900 dark:text-white">${{ number_format($totalValue ?? 0, 2) }}</p>
                    </div>
                    <div class="p-3 bg-green-100 dark:bg-green-900/20 rounded-full">
                        <svg class="w-6 h-6 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-secondary-800 rounded-lg shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-secondary-600 dark:text-secondary-400">Recent Movements</p>
                        <p class="text-2xl font-bold text-secondary-900 dark:text-white">{{ count($recentMovements ?? []) }}</p>
                    </div>
                    <div class="p-3 bg-blue-100 dark:bg-blue-900/20 rounded-full">
                        <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="bg-white dark:bg-secondary-800 rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-secondary-900 dark:text-white mb-4">Welcome to Inventory Management</h2>
            <p class="text-secondary-600 dark:text-secondary-400">
                This is your inventory management dashboard. Use the navigation menu to manage units, items, categories, stock levels, and more.
            </p>
        </div>
    </div>
</x-layouts.tenant>
