<?php

use App\Http\Controllers\Tenant\Inventory\DashboardController;
use App\Http\Controllers\Tenant\Inventory\ItemsController;
use App\Http\Controllers\Tenant\Inventory\StockController;
use App\Http\Controllers\Tenant\Inventory\CategoriesController;
use App\Http\Controllers\Tenant\Inventory\UnitsController;
use App\Http\Controllers\Tenant\Inventory\SuppliersController;
use App\Http\Controllers\Tenant\Inventory\PurchaseOrdersController;
use App\Http\Controllers\Tenant\Inventory\RecipesController;
use App\Http\Controllers\Tenant\Inventory\MovementsController;
use App\Http\Controllers\Tenant\Inventory\ReportsController;
use App\Http\Controllers\Tenant\Inventory\SettingsController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'verified', 'onboarding.completed'])->prefix('inventory')->name('inventory.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Items Management
    Route::prefix('items')->name('items.')->group(function () {
        Route::get('/', [ItemsController::class, 'index'])->name('index');
        Route::get('/create', [ItemsController::class, 'create'])->name('create');
        Route::post('/', [ItemsController::class, 'store'])->name('store');
        Route::get('/{item}/edit', [ItemsController::class, 'edit'])->name('edit');
        Route::put('/{item}', [ItemsController::class, 'update'])->name('update');
        Route::delete('/{item}', [ItemsController::class, 'destroy'])->name('destroy');
    });

    // Stock Management
    Route::prefix('stock')->name('stock.')->group(function () {
        Route::get('/', [StockController::class, 'index'])->name('index');
        Route::post('/adjust', [StockController::class, 'adjust'])->name('adjust');
        Route::get('/movements', [StockController::class, 'movements'])->name('movements');
    });

    // Categories Management
    Route::prefix('categories')->name('categories.')->group(function () {
        Route::get('/', [CategoriesController::class, 'index'])->name('index');
        Route::post('/', [CategoriesController::class, 'store'])->name('store');
        Route::put('/{category}', [CategoriesController::class, 'update'])->name('update');
        Route::delete('/{category}', [CategoriesController::class, 'destroy'])->name('destroy');
    });

    // Units Management
    Route::prefix('units')->name('units.')->group(function () {
        Route::get('/', [UnitsController::class, 'index'])->name('index');
        Route::post('/', [UnitsController::class, 'store'])->name('store');
        Route::put('/{unit}', [UnitsController::class, 'update'])->name('update');
        Route::delete('/{unit}', [UnitsController::class, 'destroy'])->name('destroy');
    });

    // Suppliers Management
    Route::prefix('suppliers')->name('suppliers.')->group(function () {
        Route::get('/', [SuppliersController::class, 'index'])->name('index');
        Route::get('/create', [SuppliersController::class, 'create'])->name('create');
        Route::post('/', [SuppliersController::class, 'store'])->name('store');
        Route::get('/{supplier}/edit', [SuppliersController::class, 'edit'])->name('edit');
        Route::put('/{supplier}', [SuppliersController::class, 'update'])->name('update');
        Route::delete('/{supplier}', [SuppliersController::class, 'destroy'])->name('destroy');
    });

    // Purchase Orders Management
    Route::prefix('purchase-orders')->name('purchase-orders.')->group(function () {
        Route::get('/', [PurchaseOrdersController::class, 'index'])->name('index');
        Route::get('/create', [PurchaseOrdersController::class, 'create'])->name('create');
        Route::post('/', [PurchaseOrdersController::class, 'store'])->name('store');
        Route::get('/{order}/edit', [PurchaseOrdersController::class, 'edit'])->name('edit');
        Route::put('/{order}', [PurchaseOrdersController::class, 'update'])->name('update');
        Route::delete('/{order}', [PurchaseOrdersController::class, 'destroy'])->name('destroy');
        Route::post('/{order}/receive', [PurchaseOrdersController::class, 'receive'])->name('receive');
    });

    // Recipes Management
    Route::prefix('recipes')->name('recipes.')->group(function () {
        Route::get('/', [RecipesController::class, 'index'])->name('index');
        Route::get('/create', [RecipesController::class, 'create'])->name('create');
        Route::post('/', [RecipesController::class, 'store'])->name('store');
        Route::get('/{recipe}/edit', [RecipesController::class, 'edit'])->name('edit');
        Route::put('/{recipe}', [RecipesController::class, 'update'])->name('update');
        Route::delete('/{recipe}', [RecipesController::class, 'destroy'])->name('destroy');
    });

    // Movements/Transfers
    Route::prefix('movements')->name('movements.')->group(function () {
        Route::get('/', [MovementsController::class, 'index'])->name('index');
        Route::post('/', [MovementsController::class, 'store'])->name('store');
    });

    // Reports
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [ReportsController::class, 'index'])->name('index');
        Route::get('/stock-value', [ReportsController::class, 'stockValue'])->name('stock-value');
        Route::get('/low-stock', [ReportsController::class, 'lowStock'])->name('low-stock');
        Route::get('/movements', [ReportsController::class, 'movements'])->name('movements');
        Route::get('/suppliers', [ReportsController::class, 'suppliers'])->name('suppliers');
    });

    // Settings
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings');
    Route::put('/settings', [SettingsController::class, 'update'])->name('settings.update');
});
